# Install Assignment Role
# Copyright 2006 by Alexander V. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 060928 - first version

# This script must be run against each file to include the new report options.

def DoAdd():
    rt = { 'Name': 'Task' }  
    ct = [
    { 'Name': 'ResourceNames', 'Label': 'Resource\nNames', 'Path': 'ID/Assignment/TaskID/ResourceID/Resource/Name', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 80  },
    { 'Name': 'ResourcesShortNames', 'Label': 'Resource\nShort Names', 'Path': 'ID/Assignment/TaskID/ResourceID/Resource/ShortName', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 80  },
    { 'Name': 'ResourceRoles', 'Label': 'Resource\nRoles', 'Path': 'Assignment-TaskID: Resource/Name, Role', 'DataType': 't', 'AccessType': 'role', 'T': 'A', 'Edit': False,  'Width': 140  },
        ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Task/Assignment' }  
    ct = [
    { 'Name': 'Role', 'Label': 'Role', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Resource/Assignment' }  
    ct = [
    { 'Name': 'Role', 'Label': 'Role', 'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

    Data.SetUndo("Install Assignment Roles")

DoAdd()
